import pyopencl as cl
import numpy as np

ctx = cl.create_some_context()
queue = cl.CommandQueue(ctx)

mem_size = 16*1024*1024  # 16 MB lattice RAM
mem = np.zeros(mem_size, dtype=np.uint32)
regs = np.zeros(16, dtype=np.uint32)

# Load Debian kernel + initrd
kernel_bin = np.fromfile("vmlinuz.bin", dtype=np.uint32)
mem[:len(kernel_bin)] = kernel_bin

# Compile OpenCL kernel
program_src = open("hdgl_cpu.cl").read()
program = cl.Program(ctx, program_src).build()

mem_buf = cl.Buffer(ctx, cl.mem_flags.READ_WRITE | cl.mem_flags.COPY_HOST_PTR, hostbuf=mem)
regs_buf = cl.Buffer(ctx, cl.mem_flags.READ_WRITE | cl.mem_flags.COPY_HOST_PTR, hostbuf=regs)

# Launch “CPU” kernel with entry_point 0
program.hdgl_cpu(queue, (1,), None, mem_buf, regs_buf, np.uint32(mem_size), np.uint32(0))
